function batt = importBatt(dataFile)
    arguments
        dataFile string = []; 
    end

    if isempty(dataFile)
        [dataFile, path] = uigetfile({'*.xlsx;*.xls',...
            'Excel Spreadsheet (*.xlsx,*.xls)';
            '*.*',  'All Files (*.*)'}, ...
            'Select a File');
        dataFile = fullfile(path, dataFile);
    end
    [~, dataFileName] = fileparts(dataFile);

    %% Main data
    data = readtable(dataFile, 'Sheet', 'main', 'ReadRowNames', 1);
    
    batt.shortName = dataFileName;
    batt.nomCap = data.value('Nominal capacity');
    batt.nomVolt = data.value('Nominal voltage');
    batt.nomEnergy = data.value('Nominal energy');
    batt.mass = data.value('Mass');
    batt.minCurr = - data.value('Maximum charge current');
    batt.maxCurr = data.value('Maximum discharge current');
    batt.coulombicEff = data.value('Coulombic efficiency');

    % Read full name
    tmp = readcell( dataFile,'Sheet','main');
    [i,j] = find(strcmp(tmp,'Full Name'));
    batt.fullName = tmp(i,j+1);

    % Equivalent circuit model characteristics
    opts = detectImportOptions( dataFile,'Sheet','characteristics');
    opts.VariableUnitsRange = 'A2:C2';
    battData = readtable( dataFile, opts);

    % Store Req and Voc characteristics Req (ohm) = Req(SOC) and
    % Voc (V) = Voc(SOC)
    if isfield(battData, "Rdischarge")
        batt.dischrgRes = griddedInterpolant(battData.SOC, battData.Rdischarge);
        batt.chrgRes = griddedInterpolant(battData.SOC, battData.Rcharge);
    else
        batt.eqRes = griddedInterpolant(battData.SOC, battData.Req);
    end
    batt.ocVolt = griddedInterpolant(battData.SOC, battData.Voc);
    
end